<?php
// This file was auto-generated from sdk-root/src/data/sagemaker/2017-07-24/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2017-07-24', 'endpointPrefix' => 'api.sagemaker', 'jsonVersion' => '1.1', 'protocol' => 'json', 'serviceAbbreviation' => 'SageMaker', 'serviceFullName' => 'Amazon SageMaker Service', 'serviceId' => 'SageMaker', 'signatureVersion' => 'v4', 'signingName' => 'sagemaker', 'targetPrefix' => 'SageMaker', 'uid' => 'sagemaker-2017-07-24', ], 'operations' => [ 'AddTags' => [ 'name' => 'AddTags', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'AddTagsInput', ], 'output' => [ 'shape' => 'AddTagsOutput', ], ], 'CreateEndpoint' => [ 'name' => 'CreateEndpoint', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateEndpointInput', ], 'output' => [ 'shape' => 'CreateEndpointOutput', ], 'errors' => [ [ 'shape' => 'ResourceLimitExceeded', ], ], ], 'CreateEndpointConfig' => [ 'name' => 'CreateEndpointConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateEndpointConfigInput', ], 'output' => [ 'shape' => 'CreateEndpointConfigOutput', ], 'errors' => [ [ 'shape' => 'ResourceLimitExceeded', ], ], ], 'CreateHyperParameterTuningJob' => [ 'name' => 'CreateHyperParameterTuningJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateHyperParameterTuningJobRequest', ], 'output' => [ 'shape' => 'CreateHyperParameterTuningJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceInUse', ], [ 'shape' => 'ResourceLimitExceeded', ], ], ], 'CreateModel' => [ 'name' => 'CreateModel', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateModelInput', ], 'output' => [ 'shape' => 'CreateModelOutput', ], 'errors' => [ [ 'shape' => 'ResourceLimitExceeded', ], ], ], 'CreateNotebookInstance' => [ 'name' => 'CreateNotebookInstance', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateNotebookInstanceInput', ], 'output' => [ 'shape' => 'CreateNotebookInstanceOutput', ], 'errors' => [ [ 'shape' => 'ResourceLimitExceeded', ], ], ], 'CreateNotebookInstanceLifecycleConfig' => [ 'name' => 'CreateNotebookInstanceLifecycleConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateNotebookInstanceLifecycleConfigInput', ], 'output' => [ 'shape' => 'CreateNotebookInstanceLifecycleConfigOutput', ], 'errors' => [ [ 'shape' => 'ResourceLimitExceeded', ], ], ], 'CreatePresignedNotebookInstanceUrl' => [ 'name' => 'CreatePresignedNotebookInstanceUrl', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreatePresignedNotebookInstanceUrlInput', ], 'output' => [ 'shape' => 'CreatePresignedNotebookInstanceUrlOutput', ], ], 'CreateTrainingJob' => [ 'name' => 'CreateTrainingJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateTrainingJobRequest', ], 'output' => [ 'shape' => 'CreateTrainingJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceInUse', ], [ 'shape' => 'ResourceLimitExceeded', ], ], ], 'CreateTransformJob' => [ 'name' => 'CreateTransformJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateTransformJobRequest', ], 'output' => [ 'shape' => 'CreateTransformJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceInUse', ], [ 'shape' => 'ResourceLimitExceeded', ], ], ], 'DeleteEndpoint' => [ 'name' => 'DeleteEndpoint', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteEndpointInput', ], ], 'DeleteEndpointConfig' => [ 'name' => 'DeleteEndpointConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteEndpointConfigInput', ], ], 'DeleteModel' => [ 'name' => 'DeleteModel', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteModelInput', ], ], 'DeleteNotebookInstance' => [ 'name' => 'DeleteNotebookInstance', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteNotebookInstanceInput', ], ], 'DeleteNotebookInstanceLifecycleConfig' => [ 'name' => 'DeleteNotebookInstanceLifecycleConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteNotebookInstanceLifecycleConfigInput', ], ], 'DeleteTags' => [ 'name' => 'DeleteTags', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteTagsInput', ], 'output' => [ 'shape' => 'DeleteTagsOutput', ], ], 'DescribeEndpoint' => [ 'name' => 'DescribeEndpoint', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeEndpointInput', ], 'output' => [ 'shape' => 'DescribeEndpointOutput', ], ], 'DescribeEndpointConfig' => [ 'name' => 'DescribeEndpointConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeEndpointConfigInput', ], 'output' => [ 'shape' => 'DescribeEndpointConfigOutput', ], ], 'DescribeHyperParameterTuningJob' => [ 'name' => 'DescribeHyperParameterTuningJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeHyperParameterTuningJobRequest', ], 'output' => [ 'shape' => 'DescribeHyperParameterTuningJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFound', ], ], ], 'DescribeModel' => [ 'name' => 'DescribeModel', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeModelInput', ], 'output' => [ 'shape' => 'DescribeModelOutput', ], ], 'DescribeNotebookInstance' => [ 'name' => 'DescribeNotebookInstance', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeNotebookInstanceInput', ], 'output' => [ 'shape' => 'DescribeNotebookInstanceOutput', ], ], 'DescribeNotebookInstanceLifecycleConfig' => [ 'name' => 'DescribeNotebookInstanceLifecycleConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeNotebookInstanceLifecycleConfigInput', ], 'output' => [ 'shape' => 'DescribeNotebookInstanceLifecycleConfigOutput', ], ], 'DescribeTrainingJob' => [ 'name' => 'DescribeTrainingJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeTrainingJobRequest', ], 'output' => [ 'shape' => 'DescribeTrainingJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFound', ], ], ], 'DescribeTransformJob' => [ 'name' => 'DescribeTransformJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeTransformJobRequest', ], 'output' => [ 'shape' => 'DescribeTransformJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFound', ], ], ], 'ListEndpointConfigs' => [ 'name' => 'ListEndpointConfigs', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListEndpointConfigsInput', ], 'output' => [ 'shape' => 'ListEndpointConfigsOutput', ], ], 'ListEndpoints' => [ 'name' => 'ListEndpoints', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListEndpointsInput', ], 'output' => [ 'shape' => 'ListEndpointsOutput', ], ], 'ListHyperParameterTuningJobs' => [ 'name' => 'ListHyperParameterTuningJobs', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListHyperParameterTuningJobsRequest', ], 'output' => [ 'shape' => 'ListHyperParameterTuningJobsResponse', ], ], 'ListModels' => [ 'name' => 'ListModels', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListModelsInput', ], 'output' => [ 'shape' => 'ListModelsOutput', ], ], 'ListNotebookInstanceLifecycleConfigs' => [ 'name' => 'ListNotebookInstanceLifecycleConfigs', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListNotebookInstanceLifecycleConfigsInput', ], 'output' => [ 'shape' => 'ListNotebookInstanceLifecycleConfigsOutput', ], ], 'ListNotebookInstances' => [ 'name' => 'ListNotebookInstances', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListNotebookInstancesInput', ], 'output' => [ 'shape' => 'ListNotebookInstancesOutput', ], ], 'ListTags' => [ 'name' => 'ListTags', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListTagsInput', ], 'output' => [ 'shape' => 'ListTagsOutput', ], ], 'ListTrainingJobs' => [ 'name' => 'ListTrainingJobs', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListTrainingJobsRequest', ], 'output' => [ 'shape' => 'ListTrainingJobsResponse', ], ], 'ListTrainingJobsForHyperParameterTuningJob' => [ 'name' => 'ListTrainingJobsForHyperParameterTuningJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListTrainingJobsForHyperParameterTuningJobRequest', ], 'output' => [ 'shape' => 'ListTrainingJobsForHyperParameterTuningJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFound', ], ], ], 'ListTransformJobs' => [ 'name' => 'ListTransformJobs', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListTransformJobsRequest', ], 'output' => [ 'shape' => 'ListTransformJobsResponse', ], ], 'StartNotebookInstance' => [ 'name' => 'StartNotebookInstance', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StartNotebookInstanceInput', ], 'errors' => [ [ 'shape' => 'ResourceLimitExceeded', ], ], ], 'StopHyperParameterTuningJob' => [ 'name' => 'StopHyperParameterTuningJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StopHyperParameterTuningJobRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFound', ], ], ], 'StopNotebookInstance' => [ 'name' => 'StopNotebookInstance', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StopNotebookInstanceInput', ], ], 'StopTrainingJob' => [ 'name' => 'StopTrainingJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StopTrainingJobRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFound', ], ], ], 'StopTransformJob' => [ 'name' => 'StopTransformJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StopTransformJobRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFound', ], ], ], 'UpdateEndpoint' => [ 'name' => 'UpdateEndpoint', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateEndpointInput', ], 'output' => [ 'shape' => 'UpdateEndpointOutput', ], 'errors' => [ [ 'shape' => 'ResourceLimitExceeded', ], ], ], 'UpdateEndpointWeightsAndCapacities' => [ 'name' => 'UpdateEndpointWeightsAndCapacities', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateEndpointWeightsAndCapacitiesInput', ], 'output' => [ 'shape' => 'UpdateEndpointWeightsAndCapacitiesOutput', ], 'errors' => [ [ 'shape' => 'ResourceLimitExceeded', ], ], ], 'UpdateNotebookInstance' => [ 'name' => 'UpdateNotebookInstance', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateNotebookInstanceInput', ], 'output' => [ 'shape' => 'UpdateNotebookInstanceOutput', ], 'errors' => [ [ 'shape' => 'ResourceLimitExceeded', ], ], ], 'UpdateNotebookInstanceLifecycleConfig' => [ 'name' => 'UpdateNotebookInstanceLifecycleConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateNotebookInstanceLifecycleConfigInput', ], 'output' => [ 'shape' => 'UpdateNotebookInstanceLifecycleConfigOutput', ], 'errors' => [ [ 'shape' => 'ResourceLimitExceeded', ], ], ], ], 'shapes' => [ 'Accept' => [ 'type' => 'string', 'max' => 256, ], 'AddTagsInput' => [ 'type' => 'structure', 'required' => [ 'ResourceArn', 'Tags', ], 'members' => [ 'ResourceArn' => [ 'shape' => 'ResourceArn', ], 'Tags' => [ 'shape' => 'TagList', ], ], ], 'AddTagsOutput' => [ 'type' => 'structure', 'members' => [ 'Tags' => [ 'shape' => 'TagList', ], ], ], 'AlgorithmImage' => [ 'type' => 'string', 'max' => 255, ], 'AlgorithmSpecification' => [ 'type' => 'structure', 'required' => [ 'TrainingInputMode', ], 'members' => [ 'TrainingImage' => [ 'shape' => 'AlgorithmImage', ], 'TrainingInputMode' => [ 'shape' => 'TrainingInputMode', ], 'MetricDefinitions' => [ 'shape' => 'MetricDefinitionList', ], ], ], 'AssemblyType' => [ 'type' => 'string', 'enum' => [ 'None', 'Line', ], ], 'BatchStrategy' => [ 'type' => 'string', 'enum' => [ 'MultiRecord', 'SingleRecord', ], ], 'CategoricalParameterRange' => [ 'type' => 'structure', 'required' => [ 'Name', 'Values', ], 'members' => [ 'Name' => [ 'shape' => 'ParameterKey', ], 'Values' => [ 'shape' => 'ParameterValues', ], ], ], 'CategoricalParameterRanges' => [ 'type' => 'list', 'member' => [ 'shape' => 'CategoricalParameterRange', ], 'max' => 20, 'min' => 0, ], 'Channel' => [ 'type' => 'structure', 'required' => [ 'ChannelName', 'DataSource', ], 'members' => [ 'ChannelName' => [ 'shape' => 'ChannelName', ], 'DataSource' => [ 'shape' => 'DataSource', ], 'ContentType' => [ 'shape' => 'ContentType', ], 'CompressionType' => [ 'shape' => 'CompressionType', ], 'RecordWrapperType' => [ 'shape' => 'RecordWrapper', ], 'InputMode' => [ 'shape' => 'TrainingInputMode', ], ], ], 'ChannelName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[A-Za-z0-9\\.\\-_]+', ], 'CompressionType' => [ 'type' => 'string', 'enum' => [ 'None', 'Gzip', ], ], 'ContainerDefinition' => [ 'type' => 'structure', 'required' => [ 'Image', ], 'members' => [ 'ContainerHostname' => [ 'shape' => 'ContainerHostname', ], 'Image' => [ 'shape' => 'Image', ], 'ModelDataUrl' => [ 'shape' => 'Url', ], 'Environment' => [ 'shape' => 'EnvironmentMap', ], ], ], 'ContainerHostname' => [ 'type' => 'string', 'max' => 63, 'pattern' => '^[a-zA-Z0-9](-*[a-zA-Z0-9])*', ], 'ContentType' => [ 'type' => 'string', 'max' => 256, ], 'ContinuousParameterRange' => [ 'type' => 'structure', 'required' => [ 'Name', 'MinValue', 'MaxValue', ], 'members' => [ 'Name' => [ 'shape' => 'ParameterKey', ], 'MinValue' => [ 'shape' => 'ParameterValue', ], 'MaxValue' => [ 'shape' => 'ParameterValue', ], ], ], 'ContinuousParameterRanges' => [ 'type' => 'list', 'member' => [ 'shape' => 'ContinuousParameterRange', ], 'max' => 20, 'min' => 0, ], 'CreateEndpointConfigInput' => [ 'type' => 'structure', 'required' => [ 'EndpointConfigName', 'ProductionVariants', ], 'members' => [ 'EndpointConfigName' => [ 'shape' => 'EndpointConfigName', ], 'ProductionVariants' => [ 'shape' => 'ProductionVariantList', ], 'Tags' => [ 'shape' => 'TagList', ], 'KmsKeyId' => [ 'shape' => 'KmsKeyId', ], ], ], 'CreateEndpointConfigOutput' => [ 'type' => 'structure', 'required' => [ 'EndpointConfigArn', ], 'members' => [ 'EndpointConfigArn' => [ 'shape' => 'EndpointConfigArn', ], ], ], 'CreateEndpointInput' => [ 'type' => 'structure', 'required' => [ 'EndpointName', 'EndpointConfigName', ], 'members' => [ 'EndpointName' => [ 'shape' => 'EndpointName', ], 'EndpointConfigName' => [ 'shape' => 'EndpointConfigName', ], 'Tags' => [ 'shape' => 'TagList', ], ], ], 'CreateEndpointOutput' => [ 'type' => 'structure', 'required' => [ 'EndpointArn', ], 'members' => [ 'EndpointArn' => [ 'shape' => 'EndpointArn', ], ], ], 'CreateHyperParameterTuningJobRequest' => [ 'type' => 'structure', 'required' => [ 'HyperParameterTuningJobName', 'HyperParameterTuningJobConfig', 'TrainingJobDefinition', ], 'members' => [ 'HyperParameterTuningJobName' => [ 'shape' => 'HyperParameterTuningJobName', ], 'HyperParameterTuningJobConfig' => [ 'shape' => 'HyperParameterTuningJobConfig', ], 'TrainingJobDefinition' => [ 'shape' => 'HyperParameterTrainingJobDefinition', ], 'WarmStartConfig' => [ 'shape' => 'HyperParameterTuningJobWarmStartConfig', ], 'Tags' => [ 'shape' => 'TagList', ], ], ], 'CreateHyperParameterTuningJobResponse' => [ 'type' => 'structure', 'required' => [ 'HyperParameterTuningJobArn', ], 'members' => [ 'HyperParameterTuningJobArn' => [ 'shape' => 'HyperParameterTuningJobArn', ], ], ], 'CreateModelInput' => [ 'type' => 'structure', 'required' => [ 'ModelName', 'PrimaryContainer', 'ExecutionRoleArn', ], 'members' => [ 'ModelName' => [ 'shape' => 'ModelName', ], 'PrimaryContainer' => [ 'shape' => 'ContainerDefinition', ], 'ExecutionRoleArn' => [ 'shape' => 'RoleArn', ], 'Tags' => [ 'shape' => 'TagList', ], 'VpcConfig' => [ 'shape' => 'VpcConfig', ], ], ], 'CreateModelOutput' => [ 'type' => 'structure', 'required' => [ 'ModelArn', ], 'members' => [ 'ModelArn' => [ 'shape' => 'ModelArn', ], ], ], 'CreateNotebookInstanceInput' => [ 'type' => 'structure', 'required' => [ 'NotebookInstanceName', 'InstanceType', 'RoleArn', ], 'members' => [ 'NotebookInstanceName' => [ 'shape' => 'NotebookInstanceName', ], 'InstanceType' => [ 'shape' => 'InstanceType', ], 'SubnetId' => [ 'shape' => 'SubnetId', ], 'SecurityGroupIds' => [ 'shape' => 'SecurityGroupIds', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'KmsKeyId' => [ 'shape' => 'KmsKeyId', ], 'Tags' => [ 'shape' => 'TagList', ], 'LifecycleConfigName' => [ 'shape' => 'NotebookInstanceLifecycleConfigName', ], 'DirectInternetAccess' => [ 'shape' => 'DirectInternetAccess', ], 'VolumeSizeInGB' => [ 'shape' => 'NotebookInstanceVolumeSizeInGB', ], ], ], 'CreateNotebookInstanceLifecycleConfigInput' => [ 'type' => 'structure', 'required' => [ 'NotebookInstanceLifecycleConfigName', ], 'members' => [ 'NotebookInstanceLifecycleConfigName' => [ 'shape' => 'NotebookInstanceLifecycleConfigName', ], 'OnCreate' => [ 'shape' => 'NotebookInstanceLifecycleConfigList', ], 'OnStart' => [ 'shape' => 'NotebookInstanceLifecycleConfigList', ], ], ], 'CreateNotebookInstanceLifecycleConfigOutput' => [ 'type' => 'structure', 'members' => [ 'NotebookInstanceLifecycleConfigArn' => [ 'shape' => 'NotebookInstanceLifecycleConfigArn', ], ], ], 'CreateNotebookInstanceOutput' => [ 'type' => 'structure', 'members' => [ 'NotebookInstanceArn' => [ 'shape' => 'NotebookInstanceArn', ], ], ], 'CreatePresignedNotebookInstanceUrlInput' => [ 'type' => 'structure', 'required' => [ 'NotebookInstanceName', ], 'members' => [ 'NotebookInstanceName' => [ 'shape' => 'NotebookInstanceName', ], 'SessionExpirationDurationInSeconds' => [ 'shape' => 'SessionExpirationDurationInSeconds', ], ], ], 'CreatePresignedNotebookInstanceUrlOutput' => [ 'type' => 'structure', 'members' => [ 'AuthorizedUrl' => [ 'shape' => 'NotebookInstanceUrl', ], ], ], 'CreateTrainingJobRequest' => [ 'type' => 'structure', 'required' => [ 'TrainingJobName', 'AlgorithmSpecification', 'RoleArn', 'OutputDataConfig', 'ResourceConfig', 'StoppingCondition', ], 'members' => [ 'TrainingJobName' => [ 'shape' => 'TrainingJobName', ], 'HyperParameters' => [ 'shape' => 'HyperParameters', ], 'AlgorithmSpecification' => [ 'shape' => 'AlgorithmSpecification', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'InputDataConfig' => [ 'shape' => 'InputDataConfig', ], 'OutputDataConfig' => [ 'shape' => 'OutputDataConfig', ], 'ResourceConfig' => [ 'shape' => 'ResourceConfig', ], 'VpcConfig' => [ 'shape' => 'VpcConfig', ], 'StoppingCondition' => [ 'shape' => 'StoppingCondition', ], 'Tags' => [ 'shape' => 'TagList', ], ], ], 'CreateTrainingJobResponse' => [ 'type' => 'structure', 'required' => [ 'TrainingJobArn', ], 'members' => [ 'TrainingJobArn' => [ 'shape' => 'TrainingJobArn', ], ], ], 'CreateTransformJobRequest' => [ 'type' => 'structure', 'required' => [ 'TransformJobName', 'ModelName', 'TransformInput', 'TransformOutput', 'TransformResources', ], 'members' => [ 'TransformJobName' => [ 'shape' => 'TransformJobName', ], 'ModelName' => [ 'shape' => 'ModelName', ], 'MaxConcurrentTransforms' => [ 'shape' => 'MaxConcurrentTransforms', ], 'MaxPayloadInMB' => [ 'shape' => 'MaxPayloadInMB', ], 'BatchStrategy' => [ 'shape' => 'BatchStrategy', ], 'Environment' => [ 'shape' => 'TransformEnvironmentMap', ], 'TransformInput' => [ 'shape' => 'TransformInput', ], 'TransformOutput' => [ 'shape' => 'TransformOutput', ], 'TransformResources' => [ 'shape' => 'TransformResources', ], 'Tags' => [ 'shape' => 'TagList', ], ], ], 'CreateTransformJobResponse' => [ 'type' => 'structure', 'required' => [ 'TransformJobArn', ], 'members' => [ 'TransformJobArn' => [ 'shape' => 'TransformJobArn', ], ], ], 'CreationTime' => [ 'type' => 'timestamp', ], 'DataSource' => [ 'type' => 'structure', 'required' => [ 'S3DataSource', ], 'members' => [ 'S3DataSource' => [ 'shape' => 'S3DataSource', ], ], ], 'DeleteEndpointConfigInput' => [ 'type' => 'structure', 'required' => [ 'EndpointConfigName', ], 'members' => [ 'EndpointConfigName' => [ 'shape' => 'EndpointConfigName', ], ], ], 'DeleteEndpointInput' => [ 'type' => 'structure', 'required' => [ 'EndpointName', ], 'members' => [ 'EndpointName' => [ 'shape' => 'EndpointName', ], ], ], 'DeleteModelInput' => [ 'type' => 'structure', 'required' => [ 'ModelName', ], 'members' => [ 'ModelName' => [ 'shape' => 'ModelName', ], ], ], 'DeleteNotebookInstanceInput' => [ 'type' => 'structure', 'required' => [ 'NotebookInstanceName', ], 'members' => [ 'NotebookInstanceName' => [ 'shape' => 'NotebookInstanceName', ], ], ], 'DeleteNotebookInstanceLifecycleConfigInput' => [ 'type' => 'structure', 'required' => [ 'NotebookInstanceLifecycleConfigName', ], 'members' => [ 'NotebookInstanceLifecycleConfigName' => [ 'shape' => 'NotebookInstanceLifecycleConfigName', ], ], ], 'DeleteTagsInput' => [ 'type' => 'structure', 'required' => [ 'ResourceArn', 'TagKeys', ], 'members' => [ 'ResourceArn' => [ 'shape' => 'ResourceArn', ], 'TagKeys' => [ 'shape' => 'TagKeyList', ], ], ], 'DeleteTagsOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeployedImage' => [ 'type' => 'structure', 'members' => [ 'SpecifiedImage' => [ 'shape' => 'Image', ], 'ResolvedImage' => [ 'shape' => 'Image', ], 'ResolutionTime' => [ 'shape' => 'Timestamp', ], ], ], 'DeployedImages' => [ 'type' => 'list', 'member' => [ 'shape' => 'DeployedImage', ], ], 'DescribeEndpointConfigInput' => [ 'type' => 'structure', 'required' => [ 'EndpointConfigName', ], 'members' => [ 'EndpointConfigName' => [ 'shape' => 'EndpointConfigName', ], ], ], 'DescribeEndpointConfigOutput' => [ 'type' => 'structure', 'required' => [ 'EndpointConfigName', 'EndpointConfigArn', 'ProductionVariants', 'CreationTime', ], 'members' => [ 'EndpointConfigName' => [ 'shape' => 'EndpointConfigName', ], 'EndpointConfigArn' => [ 'shape' => 'EndpointConfigArn', ], 'ProductionVariants' => [ 'shape' => 'ProductionVariantList', ], 'KmsKeyId' => [ 'shape' => 'KmsKeyId', ], 'CreationTime' => [ 'shape' => 'Timestamp', ], ], ], 'DescribeEndpointInput' => [ 'type' => 'structure', 'required' => [ 'EndpointName', ], 'members' => [ 'EndpointName' => [ 'shape' => 'EndpointName', ], ], ], 'DescribeEndpointOutput' => [ 'type' => 'structure', 'required' => [ 'EndpointName', 'EndpointArn', 'EndpointConfigName', 'EndpointStatus', 'CreationTime', 'LastModifiedTime', ], 'members' => [ 'EndpointName' => [ 'shape' => 'EndpointName', ], 'EndpointArn' => [ 'shape' => 'EndpointArn', ], 'EndpointConfigName' => [ 'shape' => 'EndpointConfigName', ], 'ProductionVariants' => [ 'shape' => 'ProductionVariantSummaryList', ], 'EndpointStatus' => [ 'shape' => 'EndpointStatus', ], 'FailureReason' => [ 'shape' => 'FailureReason', ], 'CreationTime' => [ 'shape' => 'Timestamp', ], 'LastModifiedTime' => [ 'shape' => 'Timestamp', ], ], ], 'DescribeHyperParameterTuningJobRequest' => [ 'type' => 'structure', 'required' => [ 'HyperParameterTuningJobName', ], 'members' => [ 'HyperParameterTuningJobName' => [ 'shape' => 'HyperParameterTuningJobName', ], ], ], 'DescribeHyperParameterTuningJobResponse' => [ 'type' => 'structure', 'required' => [ 'HyperParameterTuningJobName', 'HyperParameterTuningJobArn', 'HyperParameterTuningJobConfig', 'TrainingJobDefinition', 'HyperParameterTuningJobStatus', 'CreationTime', 'TrainingJobStatusCounters', 'ObjectiveStatusCounters', ], 'members' => [ 'HyperParameterTuningJobName' => [ 'shape' => 'HyperParameterTuningJobName', ], 'HyperParameterTuningJobArn' => [ 'shape' => 'HyperParameterTuningJobArn', ], 'HyperParameterTuningJobConfig' => [ 'shape' => 'HyperParameterTuningJobConfig', ], 'TrainingJobDefinition' => [ 'shape' => 'HyperParameterTrainingJobDefinition', ], 'HyperParameterTuningJobStatus' => [ 'shape' => 'HyperParameterTuningJobStatus', ], 'CreationTime' => [ 'shape' => 'Timestamp', ], 'HyperParameterTuningEndTime' => [ 'shape' => 'Timestamp', ], 'LastModifiedTime' => [ 'shape' => 'Timestamp', ], 'TrainingJobStatusCounters' => [ 'shape' => 'TrainingJobStatusCounters', ], 'ObjectiveStatusCounters' => [ 'shape' => 'ObjectiveStatusCounters', ], 'BestTrainingJob' => [ 'shape' => 'HyperParameterTrainingJobSummary', ], 'OverallBestTrainingJob' => [ 'shape' => 'HyperParameterTrainingJobSummary', ], 'WarmStartConfig' => [ 'shape' => 'HyperParameterTuningJobWarmStartConfig', ], 'FailureReason' => [ 'shape' => 'FailureReason', ], ], ], 'DescribeModelInput' => [ 'type' => 'structure', 'required' => [ 'ModelName', ], 'members' => [ 'ModelName' => [ 'shape' => 'ModelName', ], ], ], 'DescribeModelOutput' => [ 'type' => 'structure', 'required' => [ 'ModelName', 'PrimaryContainer', 'ExecutionRoleArn', 'CreationTime', 'ModelArn', ], 'members' => [ 'ModelName' => [ 'shape' => 'ModelName', ], 'PrimaryContainer' => [ 'shape' => 'ContainerDefinition', ], 'ExecutionRoleArn' => [ 'shape' => 'RoleArn', ], 'VpcConfig' => [ 'shape' => 'VpcConfig', ], 'CreationTime' => [ 'shape' => 'Timestamp', ], 'ModelArn' => [ 'shape' => 'ModelArn', ], ], ], 'DescribeNotebookInstanceInput' => [ 'type' => 'structure', 'required' => [ 'NotebookInstanceName', ], 'members' => [ 'NotebookInstanceName' => [ 'shape' => 'NotebookInstanceName', ], ], ], 'DescribeNotebookInstanceLifecycleConfigInput' => [ 'type' => 'structure', 'required' => [ 'NotebookInstanceLifecycleConfigName', ], 'members' => [ 'NotebookInstanceLifecycleConfigName' => [ 'shape' => 'NotebookInstanceLifecycleConfigName', ], ], ], 'DescribeNotebookInstanceLifecycleConfigOutput' => [ 'type' => 'structure', 'members' => [ 'NotebookInstanceLifecycleConfigArn' => [ 'shape' => 'NotebookInstanceLifecycleConfigArn', ], 'NotebookInstanceLifecycleConfigName' => [ 'shape' => 'NotebookInstanceLifecycleConfigName', ], 'OnCreate' => [ 'shape' => 'NotebookInstanceLifecycleConfigList', ], 'OnStart' => [ 'shape' => 'NotebookInstanceLifecycleConfigList', ], 'LastModifiedTime' => [ 'shape' => 'LastModifiedTime', ], 'CreationTime' => [ 'shape' => 'CreationTime', ], ], ], 'DescribeNotebookInstanceOutput' => [ 'type' => 'structure', 'members' => [ 'NotebookInstanceArn' => [ 'shape' => 'NotebookInstanceArn', ], 'NotebookInstanceName' => [ 'shape' => 'NotebookInstanceName', ], 'NotebookInstanceStatus' => [ 'shape' => 'NotebookInstanceStatus', ], 'FailureReason' => [ 'shape' => 'FailureReason', ], 'Url' => [ 'shape' => 'NotebookInstanceUrl', ], 'InstanceType' => [ 'shape' => 'InstanceType', ], 'SubnetId' => [ 'shape' => 'SubnetId', ], 'SecurityGroups' => [ 'shape' => 'SecurityGroupIds', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'KmsKeyId' => [ 'shape' => 'KmsKeyId', ], 'NetworkInterfaceId' => [ 'shape' => 'NetworkInterfaceId', ], 'LastModifiedTime' => [ 'shape' => 'LastModifiedTime', ], 'CreationTime' => [ 'shape' => 'CreationTime', ], 'NotebookInstanceLifecycleConfigName' => [ 'shape' => 'NotebookInstanceLifecycleConfigName', ], 'DirectInternetAccess' => [ 'shape' => 'DirectInternetAccess', ], 'VolumeSizeInGB' => [ 'shape' => 'NotebookInstanceVolumeSizeInGB', ], ], ], 'DescribeTrainingJobRequest' => [ 'type' => 'structure', 'required' => [ 'TrainingJobName', ], 'members' => [ 'TrainingJobName' => [ 'shape' => 'TrainingJobName', ], ], ], 'DescribeTrainingJobResponse' => [ 'type' => 'structure', 'required' => [ 'TrainingJobName', 'TrainingJobArn', 'ModelArtifacts', 'TrainingJobStatus', 'SecondaryStatus', 'AlgorithmSpecification', 'ResourceConfig', 'StoppingCondition', 'CreationTime', ], 'members' => [ 'TrainingJobName' => [ 'shape' => 'TrainingJobName', ], 'TrainingJobArn' => [ 'shape' => 'TrainingJobArn', ], 'TuningJobArn' => [ 'shape' => 'HyperParameterTuningJobArn', ], 'ModelArtifacts' => [ 'shape' => 'ModelArtifacts', ], 'TrainingJobStatus' => [ 'shape' => 'TrainingJobStatus', ], 'SecondaryStatus' => [ 'shape' => 'SecondaryStatus', ], 'FailureReason' => [ 'shape' => 'FailureReason', ], 'HyperParameters' => [ 'shape' => 'HyperParameters', ], 'AlgorithmSpecification' => [ 'shape' => 'AlgorithmSpecification', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'InputDataConfig' => [ 'shape' => 'InputDataConfig', ], 'OutputDataConfig' => [ 'shape' => 'OutputDataConfig', ], 'ResourceConfig' => [ 'shape' => 'ResourceConfig', ], 'VpcConfig' => [ 'shape' => 'VpcConfig', ], 'StoppingCondition' => [ 'shape' => 'StoppingCondition', ], 'CreationTime' => [ 'shape' => 'Timestamp', ], 'TrainingStartTime' => [ 'shape' => 'Timestamp', ], 'TrainingEndTime' => [ 'shape' => 'Timestamp', ], 'LastModifiedTime' => [ 'shape' => 'Timestamp', ], 'SecondaryStatusTransitions' => [ 'shape' => 'SecondaryStatusTransitions', ], 'FinalMetricDataList' => [ 'shape' => 'FinalMetricDataList', ], ], ], 'DescribeTransformJobRequest' => [ 'type' => 'structure', 'required' => [ 'TransformJobName', ], 'members' => [ 'TransformJobName' => [ 'shape' => 'TransformJobName', ], ], ], 'DescribeTransformJobResponse' => [ 'type' => 'structure', 'required' => [ 'TransformJobName', 'TransformJobArn', 'TransformJobStatus', 'ModelName', 'TransformInput', 'TransformResources', 'CreationTime', ], 'members' => [ 'TransformJobName' => [ 'shape' => 'TransformJobName', ], 'TransformJobArn' => [ 'shape' => 'TransformJobArn', ], 'TransformJobStatus' => [ 'shape' => 'TransformJobStatus', ], 'FailureReason' => [ 'shape' => 'FailureReason', ], 'ModelName' => [ 'shape' => 'ModelName', ], 'MaxConcurrentTransforms' => [ 'shape' => 'MaxConcurrentTransforms', ], 'MaxPayloadInMB' => [ 'shape' => 'MaxPayloadInMB', ], 'BatchStrategy' => [ 'shape' => 'BatchStrategy', ], 'Environment' => [ 'shape' => 'TransformEnvironmentMap', ], 'TransformInput' => [ 'shape' => 'TransformInput', ], 'TransformOutput' => [ 'shape' => 'TransformOutput', ], 'TransformResources' => [ 'shape' => 'TransformResources', ], 'CreationTime' => [ 'shape' => 'Timestamp', ], 'TransformStartTime' => [ 'shape' => 'Timestamp', ], 'TransformEndTime' => [ 'shape' => 'Timestamp', ], ], ], 'DesiredWeightAndCapacity' => [ 'type' => 'structure', 'required' => [ 'VariantName', ], 'members' => [ 'VariantName' => [ 'shape' => 'VariantName', ], 'DesiredWeight' => [ 'shape' => 'VariantWeight', ], 'DesiredInstanceCount' => [ 'shape' => 'TaskCount', ], ], ], 'DesiredWeightAndCapacityList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DesiredWeightAndCapacity', ], 'min' => 1, ], 'DirectInternetAccess' => [ 'type' => 'string', 'enum' => [ 'Enabled', 'Disabled', ], ], 'DisassociateNotebookInstanceLifecycleConfig' => [ 'type' => 'boolean', ], 'EndpointArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, ], 'EndpointConfigArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, ], 'EndpointConfigName' => [ 'type' => 'string', 'max' => 63, 'pattern' => '^[a-zA-Z0-9](-*[a-zA-Z0-9])*', ], 'EndpointConfigNameContains' => [ 'type' => 'string', 'max' => 63, 'pattern' => '[a-zA-Z0-9-]+', ], 'EndpointConfigSortKey' => [ 'type' => 'string', 'enum' => [ 'Name', 'CreationTime', ], ], 'EndpointConfigSummary' => [ 'type' => 'structure', 'required' => [ 'EndpointConfigName', 'EndpointConfigArn', 'CreationTime', ], 'members' => [ 'EndpointConfigName' => [ 'shape' => 'EndpointConfigName', ], 'EndpointConfigArn' => [ 'shape' => 'EndpointConfigArn', ], 'CreationTime' => [ 'shape' => 'Timestamp', ], ], ], 'EndpointConfigSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EndpointConfigSummary', ], ], 'EndpointName' => [ 'type' => 'string', 'max' => 63, 'pattern' => '^[a-zA-Z0-9](-*[a-zA-Z0-9])*', ], 'EndpointNameContains' => [ 'type' => 'string', 'max' => 63, 'pattern' => '[a-zA-Z0-9-]+', ], 'EndpointSortKey' => [ 'type' => 'string', 'enum' => [ 'Name', 'CreationTime', 'Status', ], ], 'EndpointStatus' => [ 'type' => 'string', 'enum' => [ 'OutOfService', 'Creating', 'Updating', 'SystemUpdating', 'RollingBack', 'InService', 'Deleting', 'Failed', ], ], 'EndpointSummary' => [ 'type' => 'structure', 'required' => [ 'EndpointName', 'EndpointArn', 'CreationTime', 'LastModifiedTime', 'EndpointStatus', ], 'members' => [ 'EndpointName' => [ 'shape' => 'EndpointName', ], 'EndpointArn' => [ 'shape' => 'EndpointArn', ], 'CreationTime' => [ 'shape' => 'Timestamp', ], 'LastModifiedTime' => [ 'shape' => 'Timestamp', ], 'EndpointStatus' => [ 'shape' => 'EndpointStatus', ], ], ], 'EndpointSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EndpointSummary', ], ], 'EnvironmentKey' => [ 'type' => 'string', 'max' => 1024, 'pattern' => '[a-zA-Z_][a-zA-Z0-9_]*', ], 'EnvironmentMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'EnvironmentKey', ], 'value' => [ 'shape' => 'EnvironmentValue', ], 'max' => 16, ], 'EnvironmentValue' => [ 'type' => 'string', 'max' => 1024, ], 'FailureReason' => [ 'type' => 'string', 'max' => 1024, ], 'FinalHyperParameterTuningJobObjectiveMetric' => [ 'type' => 'structure', 'required' => [ 'MetricName', 'Value', ], 'members' => [ 'Type' => [ 'shape' => 'HyperParameterTuningJobObjectiveType', ], 'MetricName' => [ 'shape' => 'MetricName', ], 'Value' => [ 'shape' => 'MetricValue', ], ], ], 'FinalMetricDataList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MetricData', ], 'max' => 20, 'min' => 0, ], 'Float' => [ 'type' => 'float', ], 'HyperParameterAlgorithmSpecification' => [ 'type' => 'structure', 'required' => [ 'TrainingInputMode', ], 'members' => [ 'TrainingImage' => [ 'shape' => 'AlgorithmImage', ], 'TrainingInputMode' => [ 'shape' => 'TrainingInputMode', ], 'MetricDefinitions' => [ 'shape' => 'MetricDefinitionList', ], ], ], 'HyperParameterTrainingJobDefinition' => [ 'type' => 'structure', 'required' => [ 'AlgorithmSpecification', 'RoleArn', 'OutputDataConfig', 'ResourceConfig', 'StoppingCondition', ], 'members' => [ 'StaticHyperParameters' => [ 'shape' => 'HyperParameters', ], 'AlgorithmSpecification' => [ 'shape' => 'HyperParameterAlgorithmSpecification', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'InputDataConfig' => [ 'shape' => 'InputDataConfig', ], 'VpcConfig' => [ 'shape' => 'VpcConfig', ], 'OutputDataConfig' => [ 'shape' => 'OutputDataConfig', ], 'ResourceConfig' => [ 'shape' => 'ResourceConfig', ], 'StoppingCondition' => [ 'shape' => 'StoppingCondition', ], ], ], 'HyperParameterTrainingJobSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'HyperParameterTrainingJobSummary', ], ], 'HyperParameterTrainingJobSummary' => [ 'type' => 'structure', 'required' => [ 'TrainingJobName', 'TrainingJobArn', 'CreationTime', 'TrainingJobStatus', 'TunedHyperParameters', ], 'members' => [ 'TrainingJobName' => [ 'shape' => 'TrainingJobName', ], 'TrainingJobArn' => [ 'shape' => 'TrainingJobArn', ], 'TuningJobName' => [ 'shape' => 'HyperParameterTuningJobName', ], 'CreationTime' => [ 'shape' => 'Timestamp', ], 'TrainingStartTime' => [ 'shape' => 'Timestamp', ], 'TrainingEndTime' => [ 'shape' => 'Timestamp', ], 'TrainingJobStatus' => [ 'shape' => 'TrainingJobStatus', ], 'TunedHyperParameters' => [ 'shape' => 'HyperParameters', ], 'FailureReason' => [ 'shape' => 'FailureReason', ], 'FinalHyperParameterTuningJobObjectiveMetric' => [ 'shape' => 'FinalHyperParameterTuningJobObjectiveMetric', ], 'ObjectiveStatus' => [ 'shape' => 'ObjectiveStatus', ], ], ], 'HyperParameterTuningJobArn' => [ 'type' => 'string', 'max' => 256, 'pattern' => 'arn:aws[a-z\\-]*:sagemaker:[a-z0-9\\-]*:[0-9]{12}:hyper-parameter-tuning-job/.*', ], 'HyperParameterTuningJobConfig' => [ 'type' => 'structure', 'required' => [ 'Strategy', 'HyperParameterTuningJobObjective', 'ResourceLimits', 'ParameterRanges', ], 'members' => [ 'Strategy' => [ 'shape' => 'HyperParameterTuningJobStrategyType', ], 'HyperParameterTuningJobObjective' => [ 'shape' => 'HyperParameterTuningJobObjective', ], 'ResourceLimits' => [ 'shape' => 'ResourceLimits', ], 'ParameterRanges' => [ 'shape' => 'ParameterRanges', ], ], ], 'HyperParameterTuningJobName' => [ 'type' => 'string', 'max' => 32, 'min' => 1, 'pattern' => '^[a-zA-Z0-9](-*[a-zA-Z0-9])*', ], 'HyperParameterTuningJobObjective' => [ 'type' => 'structure', 'required' => [ 'Type', 'MetricName', ], 'members' => [ 'Type' => [ 'shape' => 'HyperParameterTuningJobObjectiveType', ], 'MetricName' => [ 'shape' => 'MetricName', ], ], ], 'HyperParameterTuningJobObjectiveType' => [ 'type' => 'string', 'enum' => [ 'Maximize', 'Minimize', ], ], 'HyperParameterTuningJobSortByOptions' => [ 'type' => 'string', 'enum' => [ 'Name', 'Status', 'CreationTime', ], ], 'HyperParameterTuningJobStatus' => [ 'type' => 'string', 'enum' => [ 'Completed', 'InProgress', 'Failed', 'Stopped', 'Stopping', ], ], 'HyperParameterTuningJobStrategyType' => [ 'type' => 'string', 'enum' => [ 'Bayesian', ], ], 'HyperParameterTuningJobSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'HyperParameterTuningJobSummary', ], ], 'HyperParameterTuningJobSummary' => [ 'type' => 'structure', 'required' => [ 'HyperParameterTuningJobName', 'HyperParameterTuningJobArn', 'HyperParameterTuningJobStatus', 'Strategy', 'CreationTime', 'TrainingJobStatusCounters', 'ObjectiveStatusCounters', ], 'members' => [ 'HyperParameterTuningJobName' => [ 'shape' => 'HyperParameterTuningJobName', ], 'HyperParameterTuningJobArn' => [ 'shape' => 'HyperParameterTuningJobArn', ], 'HyperParameterTuningJobStatus' => [ 'shape' => 'HyperParameterTuningJobStatus', ], 'Strategy' => [ 'shape' => 'HyperParameterTuningJobStrategyType', ], 'CreationTime' => [ 'shape' => 'Timestamp', ], 'HyperParameterTuningEndTime' => [ 'shape' => 'Timestamp', ], 'LastModifiedTime' => [ 'shape' => 'Timestamp', ], 'TrainingJobStatusCounters' => [ 'shape' => 'TrainingJobStatusCounters', ], 'ObjectiveStatusCounters' => [ 'shape' => 'ObjectiveStatusCounters', ], 'ResourceLimits' => [ 'shape' => 'ResourceLimits', ], ], ], 'HyperParameterTuningJobWarmStartConfig' => [ 'type' => 'structure', 'required' => [ 'ParentHyperParameterTuningJobs', 'WarmStartType', ], 'members' => [ 'ParentHyperParameterTuningJobs' => [ 'shape' => 'ParentHyperParameterTuningJobs', ], 'WarmStartType' => [ 'shape' => 'HyperParameterTuningJobWarmStartType', ], ], ], 'HyperParameterTuningJobWarmStartType' => [ 'type' => 'string', 'enum' => [ 'IdenticalDataAndAlgorithm', 'TransferLearning', ], ], 'HyperParameters' => [ 'type' => 'map', 'key' => [ 'shape' => 'ParameterKey', ], 'value' => [ 'shape' => 'ParameterValue', ], 'max' => 100, 'min' => 0, ], 'Image' => [ 'type' => 'string', 'max' => 255, 'pattern' => '[\\S]+', ], 'InputDataConfig' => [ 'type' => 'list', 'member' => [ 'shape' => 'Channel', ], 'max' => 8, 'min' => 1, ], 'InstanceType' => [ 'type' => 'string', 'enum' => [ 'ml.t2.medium', 'ml.t2.large', 'ml.t2.xlarge', 'ml.t2.2xlarge', 'ml.t3.medium', 'ml.t3.large', 'ml.t3.xlarge', 'ml.t3.2xlarge', 'ml.m4.xlarge', 'ml.m4.2xlarge', 'ml.m4.4xlarge', 'ml.m4.10xlarge', 'ml.m4.16xlarge', 'ml.m5.xlarge', 'ml.m5.2xlarge', 'ml.m5.4xlarge', 'ml.m5.12xlarge', 'ml.m5.24xlarge', 'ml.c4.xlarge', 'ml.c4.2xlarge', 'ml.c4.4xlarge', 'ml.c4.8xlarge', 'ml.c5.xlarge', 'ml.c5.2xlarge', 'ml.c5.4xlarge', 'ml.c5.9xlarge', 'ml.c5.18xlarge', 'ml.c5d.xlarge', 'ml.c5d.2xlarge', 'ml.c5d.4xlarge', 'ml.c5d.9xlarge', 'ml.c5d.18xlarge', 'ml.p2.xlarge', 'ml.p2.8xlarge', 'ml.p2.16xlarge', 'ml.p3.2xlarge', 'ml.p3.8xlarge', 'ml.p3.16xlarge', ], ], 'IntegerParameterRange' => [ 'type' => 'structure', 'required' => [ 'Name', 'MinValue', 'MaxValue', ], 'members' => [ 'Name' => [ 'shape' => 'ParameterKey', ], 'MinValue' => [ 'shape' => 'ParameterValue', ], 'MaxValue' => [ 'shape' => 'ParameterValue', ], ], ], 'IntegerParameterRanges' => [ 'type' => 'list', 'member' => [ 'shape' => 'IntegerParameterRange', ], 'max' => 20, 'min' => 0, ], 'KmsKeyId' => [ 'type' => 'string', 'max' => 2048, ], 'LastModifiedTime' => [ 'type' => 'timestamp', ], 'ListEndpointConfigsInput' => [ 'type' => 'structure', 'members' => [ 'SortBy' => [ 'shape' => 'EndpointConfigSortKey', ], 'SortOrder' => [ 'shape' => 'OrderKey', ], 'NextToken' => [ 'shape' => 'PaginationToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], 'NameContains' => [ 'shape' => 'EndpointConfigNameContains', ], 'CreationTimeBefore' => [ 'shape' => 'Timestamp', ], 'CreationTimeAfter' => [ 'shape' => 'Timestamp', ], ], ], 'ListEndpointConfigsOutput' => [ 'type' => 'structure', 'required' => [ 'EndpointConfigs', ], 'members' => [ 'EndpointConfigs' => [ 'shape' => 'EndpointConfigSummaryList', ], 'NextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListEndpointsInput' => [ 'type' => 'structure', 'members' => [ 'SortBy' => [ 'shape' => 'EndpointSortKey', ], 'SortOrder' => [ 'shape' => 'OrderKey', ], 'NextToken' => [ 'shape' => 'PaginationToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], 'NameContains' => [ 'shape' => 'EndpointNameContains', ], 'CreationTimeBefore' => [ 'shape' => 'Timestamp', ], 'CreationTimeAfter' => [ 'shape' => 'Timestamp', ], 'LastModifiedTimeBefore' => [ 'shape' => 'Timestamp', ], 'LastModifiedTimeAfter' => [ 'shape' => 'Timestamp', ], 'StatusEquals' => [ 'shape' => 'EndpointStatus', ], ], ], 'ListEndpointsOutput' => [ 'type' => 'structure', 'required' => [ 'Endpoints', ], 'members' => [ 'Endpoints' => [ 'shape' => 'EndpointSummaryList', ], 'NextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListHyperParameterTuningJobsRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'box' => true, ], 'SortBy' => [ 'shape' => 'HyperParameterTuningJobSortByOptions', ], 'SortOrder' => [ 'shape' => 'SortOrder', ], 'NameContains' => [ 'shape' => 'NameContains', ], 'CreationTimeAfter' => [ 'shape' => 'Timestamp', ], 'CreationTimeBefore' => [ 'shape' => 'Timestamp', ], 'LastModifiedTimeAfter' => [ 'shape' => 'Timestamp', ], 'LastModifiedTimeBefore' => [ 'shape' => 'Timestamp', ], 'StatusEquals' => [ 'shape' => 'HyperParameterTuningJobStatus', ], ], ], 'ListHyperParameterTuningJobsResponse' => [ 'type' => 'structure', 'required' => [ 'HyperParameterTuningJobSummaries', ], 'members' => [ 'HyperParameterTuningJobSummaries' => [ 'shape' => 'HyperParameterTuningJobSummaries', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListModelsInput' => [ 'type' => 'structure', 'members' => [ 'SortBy' => [ 'shape' => 'ModelSortKey', ], 'SortOrder' => [ 'shape' => 'OrderKey', ], 'NextToken' => [ 'shape' => 'PaginationToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], 'NameContains' => [ 'shape' => 'ModelNameContains', ], 'CreationTimeBefore' => [ 'shape' => 'Timestamp', ], 'CreationTimeAfter' => [ 'shape' => 'Timestamp', ], ], ], 'ListModelsOutput' => [ 'type' => 'structure', 'required' => [ 'Models', ], 'members' => [ 'Models' => [ 'shape' => 'ModelSummaryList', ], 'NextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListNotebookInstanceLifecycleConfigsInput' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], 'SortBy' => [ 'shape' => 'NotebookInstanceLifecycleConfigSortKey', ], 'SortOrder' => [ 'shape' => 'NotebookInstanceLifecycleConfigSortOrder', ], 'NameContains' => [ 'shape' => 'NotebookInstanceLifecycleConfigNameContains', ], 'CreationTimeBefore' => [ 'shape' => 'CreationTime', ], 'CreationTimeAfter' => [ 'shape' => 'CreationTime', ], 'LastModifiedTimeBefore' => [ 'shape' => 'LastModifiedTime', ], 'LastModifiedTimeAfter' => [ 'shape' => 'LastModifiedTime', ], ], ], 'ListNotebookInstanceLifecycleConfigsOutput' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'NotebookInstanceLifecycleConfigs' => [ 'shape' => 'NotebookInstanceLifecycleConfigSummaryList', ], ], ], 'ListNotebookInstancesInput' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], 'SortBy' => [ 'shape' => 'NotebookInstanceSortKey', ], 'SortOrder' => [ 'shape' => 'NotebookInstanceSortOrder', ], 'NameContains' => [ 'shape' => 'NotebookInstanceNameContains', ], 'CreationTimeBefore' => [ 'shape' => 'CreationTime', ], 'CreationTimeAfter' => [ 'shape' => 'CreationTime', ], 'LastModifiedTimeBefore' => [ 'shape' => 'LastModifiedTime', ], 'LastModifiedTimeAfter' => [ 'shape' => 'LastModifiedTime', ], 'StatusEquals' => [ 'shape' => 'NotebookInstanceStatus', ], 'NotebookInstanceLifecycleConfigNameContains' => [ 'shape' => 'NotebookInstanceLifecycleConfigName', ], ], ], 'ListNotebookInstancesOutput' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'NotebookInstances' => [ 'shape' => 'NotebookInstanceSummaryList', ], ], ], 'ListTagsInput' => [ 'type' => 'structure', 'required' => [ 'ResourceArn', ], 'members' => [ 'ResourceArn' => [ 'shape' => 'ResourceArn', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'ListTagsMaxResults', ], ], ], 'ListTagsMaxResults' => [ 'type' => 'integer', 'min' => 50, ], 'ListTagsOutput' => [ 'type' => 'structure', 'members' => [ 'Tags' => [ 'shape' => 'TagList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTrainingJobsForHyperParameterTuningJobRequest' => [ 'type' => 'structure', 'required' => [ 'HyperParameterTuningJobName', ], 'members' => [ 'HyperParameterTuningJobName' => [ 'shape' => 'HyperParameterTuningJobName', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], 'StatusEquals' => [ 'shape' => 'TrainingJobStatus', ], 'SortBy' => [ 'shape' => 'TrainingJobSortByOptions', ], 'SortOrder' => [ 'shape' => 'SortOrder', ], ], ], 'ListTrainingJobsForHyperParameterTuningJobResponse' => [ 'type' => 'structure', 'required' => [ 'TrainingJobSummaries', ], 'members' => [ 'TrainingJobSummaries' => [ 'shape' => 'HyperParameterTrainingJobSummaries', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTrainingJobsRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'box' => true, ], 'CreationTimeAfter' => [ 'shape' => 'Timestamp', ], 'CreationTimeBefore' => [ 'shape' => 'Timestamp', ], 'LastModifiedTimeAfter' => [ 'shape' => 'Timestamp', ], 'LastModifiedTimeBefore' => [ 'shape' => 'Timestamp', ], 'NameContains' => [ 'shape' => 'NameContains', ], 'StatusEquals' => [ 'shape' => 'TrainingJobStatus', ], 'SortBy' => [ 'shape' => 'SortBy', ], 'SortOrder' => [ 'shape' => 'SortOrder', ], ], ], 'ListTrainingJobsResponse' => [ 'type' => 'structure', 'required' => [ 'TrainingJobSummaries', ], 'members' => [ 'TrainingJobSummaries' => [ 'shape' => 'TrainingJobSummaries', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTransformJobsRequest' => [ 'type' => 'structure', 'members' => [ 'CreationTimeAfter' => [ 'shape' => 'Timestamp', ], 'CreationTimeBefore' => [ 'shape' => 'Timestamp', ], 'LastModifiedTimeAfter' => [ 'shape' => 'Timestamp', ], 'LastModifiedTimeBefore' => [ 'shape' => 'Timestamp', ], 'NameContains' => [ 'shape' => 'NameContains', ], 'StatusEquals' => [ 'shape' => 'TransformJobStatus', ], 'SortBy' => [ 'shape' => 'SortBy', ], 'SortOrder' => [ 'shape' => 'SortOrder', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'box' => true, ], ], ], 'ListTransformJobsResponse' => [ 'type' => 'structure', 'required' => [ 'TransformJobSummaries', ], 'members' => [ 'TransformJobSummaries' => [ 'shape' => 'TransformJobSummaries', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'MaxConcurrentTransforms' => [ 'type' => 'integer', 'min' => 0, ], 'MaxNumberOfTrainingJobs' => [ 'type' => 'integer', 'min' => 1, ], 'MaxParallelTrainingJobs' => [ 'type' => 'integer', 'min' => 1, ], 'MaxPayloadInMB' => [ 'type' => 'integer', 'min' => 0, ], 'MaxResults' => [ 'type' => 'integer', 'max' => 100, 'min' => 1, ], 'MaxRuntimeInSeconds' => [ 'type' => 'integer', 'min' => 1, ], 'MetricData' => [ 'type' => 'structure', 'members' => [ 'MetricName' => [ 'shape' => 'MetricName', ], 'Value' => [ 'shape' => 'Float', ], 'Timestamp' => [ 'shape' => 'Timestamp', ], ], ], 'MetricDefinition' => [ 'type' => 'structure', 'required' => [ 'Name', 'Regex', ], 'members' => [ 'Name' => [ 'shape' => 'MetricName', ], 'Regex' => [ 'shape' => 'MetricRegex', ], ], ], 'MetricDefinitionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MetricDefinition', ], 'max' => 20, 'min' => 0, ], 'MetricName' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'MetricRegex' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'MetricValue' => [ 'type' => 'float', ], 'ModelArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, ], 'ModelArtifacts' => [ 'type' => 'structure', 'required' => [ 'S3ModelArtifacts', ], 'members' => [ 'S3ModelArtifacts' => [ 'shape' => 'S3Uri', ], ], ], 'ModelName' => [ 'type' => 'string', 'max' => 63, 'pattern' => '^[a-zA-Z0-9](-*[a-zA-Z0-9])*', ], 'ModelNameContains' => [ 'type' => 'string', 'max' => 63, 'pattern' => '[a-zA-Z0-9-]+', ], 'ModelSortKey' => [ 'type' => 'string', 'enum' => [ 'Name', 'CreationTime', ], ], 'ModelSummary' => [ 'type' => 'structure', 'required' => [ 'ModelName', 'ModelArn', 'CreationTime', ], 'members' => [ 'ModelName' => [ 'shape' => 'ModelName', ], 'ModelArn' => [ 'shape' => 'ModelArn', ], 'CreationTime' => [ 'shape' => 'Timestamp', ], ], ], 'ModelSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ModelSummary', ], ], 'NameContains' => [ 'type' => 'string', 'max' => 63, 'pattern' => '[a-zA-Z0-9\\-]+', ], 'NetworkInterfaceId' => [ 'type' => 'string', ], 'NextToken' => [ 'type' => 'string', 'max' => 8192, ], 'NotebookInstanceArn' => [ 'type' => 'string', 'max' => 256, ], 'NotebookInstanceLifecycleConfigArn' => [ 'type' => 'string', 'max' => 256, ], 'NotebookInstanceLifecycleConfigContent' => [ 'type' => 'string', 'max' => 16384, 'min' => 1, ], 'NotebookInstanceLifecycleConfigList' => [ 'type' => 'list', 'member' => [ 'shape' => 'NotebookInstanceLifecycleHook', ], 'max' => 1, ], 'NotebookInstanceLifecycleConfigName' => [ 'type' => 'string', 'max' => 63, 'pattern' => '^[a-zA-Z0-9](-*[a-zA-Z0-9])*', ], 'NotebookInstanceLifecycleConfigNameContains' => [ 'type' => 'string', 'max' => 63, 'pattern' => '[a-zA-Z0-9-]+', ], 'NotebookInstanceLifecycleConfigSortKey' => [ 'type' => 'string', 'enum' => [ 'Name', 'CreationTime', 'LastModifiedTime', ], ], 'NotebookInstanceLifecycleConfigSortOrder' => [ 'type' => 'string', 'enum' => [ 'Ascending', 'Descending', ], ], 'NotebookInstanceLifecycleConfigSummary' => [ 'type' => 'structure', 'required' => [ 'NotebookInstanceLifecycleConfigName', 'NotebookInstanceLifecycleConfigArn', ], 'members' => [ 'NotebookInstanceLifecycleConfigName' => [ 'shape' => 'NotebookInstanceLifecycleConfigName', ], 'NotebookInstanceLifecycleConfigArn' => [ 'shape' => 'NotebookInstanceLifecycleConfigArn', ], 'CreationTime' => [ 'shape' => 'CreationTime', ], 'LastModifiedTime' => [ 'shape' => 'LastModifiedTime', ], ], ], 'NotebookInstanceLifecycleConfigSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'NotebookInstanceLifecycleConfigSummary', ], ], 'NotebookInstanceLifecycleHook' => [ 'type' => 'structure', 'members' => [ 'Content' => [ 'shape' => 'NotebookInstanceLifecycleConfigContent', ], ], ], 'NotebookInstanceName' => [ 'type' => 'string', 'max' => 63, 'pattern' => '^[a-zA-Z0-9](-*[a-zA-Z0-9])*', ], 'NotebookInstanceNameContains' => [ 'type' => 'string', 'max' => 63, 'pattern' => '[a-zA-Z0-9-]+', ], 'NotebookInstanceSortKey' => [ 'type' => 'string', 'enum' => [ 'Name', 'CreationTime', 'Status', ], ], 'NotebookInstanceSortOrder' => [ 'type' => 'string', 'enum' => [ 'Ascending', 'Descending', ], ], 'NotebookInstanceStatus' => [ 'type' => 'string', 'enum' => [ 'Pending', 'InService', 'Stopping', 'Stopped', 'Failed', 'Deleting', 'Updating', ], ], 'NotebookInstanceSummary' => [ 'type' => 'structure', 'required' => [ 'NotebookInstanceName', 'NotebookInstanceArn', ], 'members' => [ 'NotebookInstanceName' => [ 'shape' => 'NotebookInstanceName', ], 'NotebookInstanceArn' => [ 'shape' => 'NotebookInstanceArn', ], 'NotebookInstanceStatus' => [ 'shape' => 'NotebookInstanceStatus', ], 'Url' => [ 'shape' => 'NotebookInstanceUrl', ], 'InstanceType' => [ 'shape' => 'InstanceType', ], 'CreationTime' => [ 'shape' => 'CreationTime', ], 'LastModifiedTime' => [ 'shape' => 'LastModifiedTime', ], 'NotebookInstanceLifecycleConfigName' => [ 'shape' => 'NotebookInstanceLifecycleConfigName', ], ], ], 'NotebookInstanceSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'NotebookInstanceSummary', ], ], 'NotebookInstanceUrl' => [ 'type' => 'string', ], 'NotebookInstanceVolumeSizeInGB' => [ 'type' => 'integer', 'max' => 16384, 'min' => 5, ], 'ObjectiveStatus' => [ 'type' => 'string', 'enum' => [ 'Succeeded', 'Pending', 'Failed', ], ], 'ObjectiveStatusCounter' => [ 'type' => 'integer', 'min' => 0, ], 'ObjectiveStatusCounters' => [ 'type' => 'structure', 'members' => [ 'Succeeded' => [ 'shape' => 'ObjectiveStatusCounter', ], 'Pending' => [ 'shape' => 'ObjectiveStatusCounter', ], 'Failed' => [ 'shape' => 'ObjectiveStatusCounter', ], ], ], 'OrderKey' => [ 'type' => 'string', 'enum' => [ 'Ascending', 'Descending', ], ], 'OutputDataConfig' => [ 'type' => 'structure', 'required' => [ 'S3OutputPath', ], 'members' => [ 'KmsKeyId' => [ 'shape' => 'KmsKeyId', ], 'S3OutputPath' => [ 'shape' => 'S3Uri', ], ], ], 'PaginationToken' => [ 'type' => 'string', 'max' => 8192, ], 'ParameterKey' => [ 'type' => 'string', 'max' => 256, ], 'ParameterRanges' => [ 'type' => 'structure', 'members' => [ 'IntegerParameterRanges' => [ 'shape' => 'IntegerParameterRanges', ], 'ContinuousParameterRanges' => [ 'shape' => 'ContinuousParameterRanges', ], 'CategoricalParameterRanges' => [ 'shape' => 'CategoricalParameterRanges', ], ], ], 'ParameterValue' => [ 'type' => 'string', 'max' => 256, ], 'ParameterValues' => [ 'type' => 'list', 'member' => [ 'shape' => 'ParameterValue', ], 'max' => 20, 'min' => 1, ], 'ParentHyperParameterTuningJob' => [ 'type' => 'structure', 'members' => [ 'HyperParameterTuningJobName' => [ 'shape' => 'HyperParameterTuningJobName', ], ], ], 'ParentHyperParameterTuningJobs' => [ 'type' => 'list', 'member' => [ 'shape' => 'ParentHyperParameterTuningJob', ], 'max' => 5, 'min' => 1, ], 'ProductionVariant' => [ 'type' => 'structure', 'required' => [ 'VariantName', 'ModelName', 'InitialInstanceCount', 'InstanceType', ], 'members' => [ 'VariantName' => [ 'shape' => 'VariantName', ], 'ModelName' => [ 'shape' => 'ModelName', ], 'InitialInstanceCount' => [ 'shape' => 'TaskCount', ], 'InstanceType' => [ 'shape' => 'ProductionVariantInstanceType', ], 'InitialVariantWeight' => [ 'shape' => 'VariantWeight', ], ], ], 'ProductionVariantInstanceType' => [ 'type' => 'string', 'enum' => [ 'ml.t2.medium', 'ml.t2.large', 'ml.t2.xlarge', 'ml.t2.2xlarge', 'ml.m4.xlarge', 'ml.m4.2xlarge', 'ml.m4.4xlarge', 'ml.m4.10xlarge', 'ml.m4.16xlarge', 'ml.m5.large', 'ml.m5.xlarge', 'ml.m5.2xlarge', 'ml.m5.4xlarge', 'ml.m5.12xlarge', 'ml.m5.24xlarge', 'ml.c4.large', 'ml.c4.xlarge', 'ml.c4.2xlarge', 'ml.c4.4xlarge', 'ml.c4.8xlarge', 'ml.p2.xlarge', 'ml.p2.8xlarge', 'ml.p2.16xlarge', 'ml.p3.2xlarge', 'ml.p3.8xlarge', 'ml.p3.16xlarge', 'ml.c5.large', 'ml.c5.xlarge', 'ml.c5.2xlarge', 'ml.c5.4xlarge', 'ml.c5.9xlarge', 'ml.c5.18xlarge', ], ], 'ProductionVariantList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProductionVariant', ], 'min' => 1, ], 'ProductionVariantSummary' => [ 'type' => 'structure', 'required' => [ 'VariantName', ], 'members' => [ 'VariantName' => [ 'shape' => 'VariantName', ], 'DeployedImages' => [ 'shape' => 'DeployedImages', ], 'CurrentWeight' => [ 'shape' => 'VariantWeight', ], 'DesiredWeight' => [ 'shape' => 'VariantWeight', ], 'CurrentInstanceCount' => [ 'shape' => 'TaskCount', ], 'DesiredInstanceCount' => [ 'shape' => 'TaskCount', ], ], ], 'ProductionVariantSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProductionVariantSummary', ], 'min' => 1, ], 'RecordWrapper' => [ 'type' => 'string', 'enum' => [ 'None', 'RecordIO', ], ], 'ResourceArn' => [ 'type' => 'string', 'max' => 256, ], 'ResourceConfig' => [ 'type' => 'structure', 'required' => [ 'InstanceType', 'InstanceCount', 'VolumeSizeInGB', ], 'members' => [ 'InstanceType' => [ 'shape' => 'TrainingInstanceType', ], 'InstanceCount' => [ 'shape' => 'TrainingInstanceCount', ], 'VolumeSizeInGB' => [ 'shape' => 'VolumeSizeInGB', ], 'VolumeKmsKeyId' => [ 'shape' => 'KmsKeyId', ], ], ], 'ResourceInUse' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'FailureReason', ], ], 'exception' => true, ], 'ResourceLimitExceeded' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'FailureReason', ], ], 'exception' => true, ], 'ResourceLimits' => [ 'type' => 'structure', 'required' => [ 'MaxNumberOfTrainingJobs', 'MaxParallelTrainingJobs', ], 'members' => [ 'MaxNumberOfTrainingJobs' => [ 'shape' => 'MaxNumberOfTrainingJobs', ], 'MaxParallelTrainingJobs' => [ 'shape' => 'MaxParallelTrainingJobs', ], ], ], 'ResourceNotFound' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'FailureReason', ], ], 'exception' => true, ], 'RoleArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => '^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$', ], 'S3DataDistribution' => [ 'type' => 'string', 'enum' => [ 'FullyReplicated', 'ShardedByS3Key', ], ], 'S3DataSource' => [ 'type' => 'structure', 'required' => [ 'S3DataType', 'S3Uri', ], 'members' => [ 'S3DataType' => [ 'shape' => 'S3DataType', ], 'S3Uri' => [ 'shape' => 'S3Uri', ], 'S3DataDistributionType' => [ 'shape' => 'S3DataDistribution', ], ], ], 'S3DataType' => [ 'type' => 'string', 'enum' => [ 'ManifestFile', 'S3Prefix', ], ], 'S3Uri' => [ 'type' => 'string', 'max' => 1024, 'pattern' => '^(https|s3)://([^/]+)/?(.*)$', ], 'SecondaryStatus' => [ 'type' => 'string', 'enum' => [ 'Starting', 'LaunchingMLInstances', 'PreparingTrainingStack', 'Downloading', 'DownloadingTrainingImage', 'Training', 'Uploading', 'Stopping', 'Stopped', 'MaxRuntimeExceeded', 'Completed', 'Failed', ], ], 'SecondaryStatusTransition' => [ 'type' => 'structure', 'required' => [ 'Status', 'StartTime', ], 'members' => [ 'Status' => [ 'shape' => 'SecondaryStatus', ], 'StartTime' => [ 'shape' => 'Timestamp', ], 'EndTime' => [ 'shape' => 'Timestamp', ], 'StatusMessage' => [ 'shape' => 'StatusMessage', ], ], ], 'SecondaryStatusTransitions' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecondaryStatusTransition', ], ], 'SecurityGroupId' => [ 'type' => 'string', 'max' => 32, ], 'SecurityGroupIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecurityGroupId', ], 'max' => 5, ], 'SessionExpirationDurationInSeconds' => [ 'type' => 'integer', 'max' => 43200, 'min' => 1800, ], 'SortBy' => [ 'type' => 'string', 'enum' => [ 'Name', 'CreationTime', 'Status', ], ], 'SortOrder' => [ 'type' => 'string', 'enum' => [ 'Ascending', 'Descending', ], ], 'SplitType' => [ 'type' => 'string', 'enum' => [ 'None', 'Line', 'RecordIO', ], ], 'StartNotebookInstanceInput' => [ 'type' => 'structure', 'required' => [ 'NotebookInstanceName', ], 'members' => [ 'NotebookInstanceName' => [ 'shape' => 'NotebookInstanceName', ], ], ], 'StatusMessage' => [ 'type' => 'string', ], 'StopHyperParameterTuningJobRequest' => [ 'type' => 'structure', 'required' => [ 'HyperParameterTuningJobName', ], 'members' => [ 'HyperParameterTuningJobName' => [ 'shape' => 'HyperParameterTuningJobName', ], ], ], 'StopNotebookInstanceInput' => [ 'type' => 'structure', 'required' => [ 'NotebookInstanceName', ], 'members' => [ 'NotebookInstanceName' => [ 'shape' => 'NotebookInstanceName', ], ], ], 'StopTrainingJobRequest' => [ 'type' => 'structure', 'required' => [ 'TrainingJobName', ], 'members' => [ 'TrainingJobName' => [ 'shape' => 'TrainingJobName', ], ], ], 'StopTransformJobRequest' => [ 'type' => 'structure', 'required' => [ 'TransformJobName', ], 'members' => [ 'TransformJobName' => [ 'shape' => 'TransformJobName', ], ], ], 'StoppingCondition' => [ 'type' => 'structure', 'members' => [ 'MaxRuntimeInSeconds' => [ 'shape' => 'MaxRuntimeInSeconds', ], ], ], 'SubnetId' => [ 'type' => 'string', 'max' => 32, ], 'Subnets' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubnetId', ], 'max' => 16, 'min' => 1, ], 'Tag' => [ 'type' => 'structure', 'required' => [ 'Key', 'Value', ], 'members' => [ 'Key' => [ 'shape' => 'TagKey', ], 'Value' => [ 'shape' => 'TagValue', ], ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^((?!aws:)[\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 50, 'min' => 1, ], 'TagList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Tag', ], 'max' => 50, 'min' => 0, ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$', ], 'TaskCount' => [ 'type' => 'integer', 'min' => 1, ], 'Timestamp' => [ 'type' => 'timestamp', ], 'TrainingInputMode' => [ 'type' => 'string', 'enum' => [ 'Pipe', 'File', ], ], 'TrainingInstanceCount' => [ 'type' => 'integer', 'min' => 1, ], 'TrainingInstanceType' => [ 'type' => 'string', 'enum' => [ 'ml.m4.xlarge', 'ml.m4.2xlarge', 'ml.m4.4xlarge', 'ml.m4.10xlarge', 'ml.m4.16xlarge', 'ml.m5.large', 'ml.m5.xlarge', 'ml.m5.2xlarge', 'ml.m5.4xlarge', 'ml.m5.12xlarge', 'ml.m5.24xlarge', 'ml.c4.xlarge', 'ml.c4.2xlarge', 'ml.c4.4xlarge', 'ml.c4.8xlarge', 'ml.p2.xlarge', 'ml.p2.8xlarge', 'ml.p2.16xlarge', 'ml.p3.2xlarge', 'ml.p3.8xlarge', 'ml.p3.16xlarge', 'ml.c5.xlarge', 'ml.c5.2xlarge', 'ml.c5.4xlarge', 'ml.c5.9xlarge', 'ml.c5.18xlarge', ], ], 'TrainingJobArn' => [ 'type' => 'string', 'max' => 256, 'pattern' => 'arn:aws[a-z\\-]*:sagemaker:[a-z0-9\\-]*:[0-9]{12}:training-job/.*', ], 'TrainingJobName' => [ 'type' => 'string', 'max' => 63, 'min' => 1, 'pattern' => '^[a-zA-Z0-9](-*[a-zA-Z0-9])*', ], 'TrainingJobSortByOptions' => [ 'type' => 'string', 'enum' => [ 'Name', 'CreationTime', 'Status', 'FinalObjectiveMetricValue', ], ], 'TrainingJobStatus' => [ 'type' => 'string', 'enum' => [ 'InProgress', 'Completed', 'Failed', 'Stopping', 'Stopped', ], ], 'TrainingJobStatusCounter' => [ 'type' => 'integer', 'min' => 0, ], 'TrainingJobStatusCounters' => [ 'type' => 'structure', 'members' => [ 'Completed' => [ 'shape' => 'TrainingJobStatusCounter', ], 'InProgress' => [ 'shape' => 'TrainingJobStatusCounter', ], 'RetryableError' => [ 'shape' => 'TrainingJobStatusCounter', ], 'NonRetryableError' => [ 'shape' => 'TrainingJobStatusCounter', ], 'Stopped' => [ 'shape' => 'TrainingJobStatusCounter', ], ], ], 'TrainingJobSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'TrainingJobSummary', ], ], 'TrainingJobSummary' => [ 'type' => 'structure', 'required' => [ 'TrainingJobName', 'TrainingJobArn', 'CreationTime', 'TrainingJobStatus', ], 'members' => [ 'TrainingJobName' => [ 'shape' => 'TrainingJobName', ], 'TrainingJobArn' => [ 'shape' => 'TrainingJobArn', ], 'CreationTime' => [ 'shape' => 'Timestamp', ], 'TrainingEndTime' => [ 'shape' => 'Timestamp', ], 'LastModifiedTime' => [ 'shape' => 'Timestamp', ], 'TrainingJobStatus' => [ 'shape' => 'TrainingJobStatus', ], ], ], 'TransformDataSource' => [ 'type' => 'structure', 'required' => [ 'S3DataSource', ], 'members' => [ 'S3DataSource' => [ 'shape' => 'TransformS3DataSource', ], ], ], 'TransformEnvironmentKey' => [ 'type' => 'string', 'max' => 1024, 'pattern' => '[a-zA-Z_][a-zA-Z0-9_]*', ], 'TransformEnvironmentMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TransformEnvironmentKey', ], 'value' => [ 'shape' => 'TransformEnvironmentValue', ], 'max' => 16, ], 'TransformEnvironmentValue' => [ 'type' => 'string', 'max' => 10240, ], 'TransformInput' => [ 'type' => 'structure', 'required' => [ 'DataSource', ], 'members' => [ 'DataSource' => [ 'shape' => 'TransformDataSource', ], 'ContentType' => [ 'shape' => 'ContentType', ], 'CompressionType' => [ 'shape' => 'CompressionType', ], 'SplitType' => [ 'shape' => 'SplitType', ], ], ], 'TransformInstanceCount' => [ 'type' => 'integer', 'min' => 1, ], 'TransformInstanceType' => [ 'type' => 'string', 'enum' => [ 'ml.m4.xlarge', 'ml.m4.2xlarge', 'ml.m4.4xlarge', 'ml.m4.10xlarge', 'ml.m4.16xlarge', 'ml.c4.xlarge', 'ml.c4.2xlarge', 'ml.c4.4xlarge', 'ml.c4.8xlarge', 'ml.p2.xlarge', 'ml.p2.8xlarge', 'ml.p2.16xlarge', 'ml.p3.2xlarge', 'ml.p3.8xlarge', 'ml.p3.16xlarge', 'ml.c5.xlarge', 'ml.c5.2xlarge', 'ml.c5.4xlarge', 'ml.c5.9xlarge', 'ml.c5.18xlarge', 'ml.m5.large', 'ml.m5.xlarge', 'ml.m5.2xlarge', 'ml.m5.4xlarge', 'ml.m5.12xlarge', 'ml.m5.24xlarge', ], ], 'TransformJobArn' => [ 'type' => 'string', 'max' => 256, 'pattern' => 'arn:aws[a-z\\-]*:sagemaker:[a-z0-9\\-]*:[0-9]{12}:transform-job/.*', ], 'TransformJobName' => [ 'type' => 'string', 'max' => 63, 'min' => 1, 'pattern' => '^[a-zA-Z0-9](-*[a-zA-Z0-9])*', ], 'TransformJobStatus' => [ 'type' => 'string', 'enum' => [ 'InProgress', 'Completed', 'Failed', 'Stopping', 'Stopped', ], ], 'TransformJobSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'TransformJobSummary', ], ], 'TransformJobSummary' => [ 'type' => 'structure', 'required' => [ 'TransformJobName', 'TransformJobArn', 'CreationTime', 'TransformJobStatus', ], 'members' => [ 'TransformJobName' => [ 'shape' => 'TransformJobName', ], 'TransformJobArn' => [ 'shape' => 'TransformJobArn', ], 'CreationTime' => [ 'shape' => 'Timestamp', ], 'TransformEndTime' => [ 'shape' => 'Timestamp', ], 'LastModifiedTime' => [ 'shape' => 'Timestamp', ], 'TransformJobStatus' => [ 'shape' => 'TransformJobStatus', ], 'FailureReason' => [ 'shape' => 'FailureReason', ], ], ], 'TransformOutput' => [ 'type' => 'structure', 'required' => [ 'S3OutputPath', ], 'members' => [ 'S3OutputPath' => [ 'shape' => 'S3Uri', ], 'Accept' => [ 'shape' => 'Accept', ], 'AssembleWith' => [ 'shape' => 'AssemblyType', ], 'KmsKeyId' => [ 'shape' => 'KmsKeyId', ], ], ], 'TransformResources' => [ 'type' => 'structure', 'required' => [ 'InstanceType', 'InstanceCount', ], 'members' => [ 'InstanceType' => [ 'shape' => 'TransformInstanceType', ], 'InstanceCount' => [ 'shape' => 'TransformInstanceCount', ], 'VolumeKmsKeyId' => [ 'shape' => 'KmsKeyId', ], ], ], 'TransformS3DataSource' => [ 'type' => 'structure', 'required' => [ 'S3DataType', 'S3Uri', ], 'members' => [ 'S3DataType' => [ 'shape' => 'S3DataType', ], 'S3Uri' => [ 'shape' => 'S3Uri', ], ], ], 'UpdateEndpointInput' => [ 'type' => 'structure', 'required' => [ 'EndpointName', 'EndpointConfigName', ], 'members' => [ 'EndpointName' => [ 'shape' => 'EndpointName', ], 'EndpointConfigName' => [ 'shape' => 'EndpointConfigName', ], ], ], 'UpdateEndpointOutput' => [ 'type' => 'structure', 'required' => [ 'EndpointArn', ], 'members' => [ 'EndpointArn' => [ 'shape' => 'EndpointArn', ], ], ], 'UpdateEndpointWeightsAndCapacitiesInput' => [ 'type' => 'structure', 'required' => [ 'EndpointName', 'DesiredWeightsAndCapacities', ], 'members' => [ 'EndpointName' => [ 'shape' => 'EndpointName', ], 'DesiredWeightsAndCapacities' => [ 'shape' => 'DesiredWeightAndCapacityList', ], ], ], 'UpdateEndpointWeightsAndCapacitiesOutput' => [ 'type' => 'structure', 'required' => [ 'EndpointArn', ], 'members' => [ 'EndpointArn' => [ 'shape' => 'EndpointArn', ], ], ], 'UpdateNotebookInstanceInput' => [ 'type' => 'structure', 'required' => [ 'NotebookInstanceName', ], 'members' => [ 'NotebookInstanceName' => [ 'shape' => 'NotebookInstanceName', ], 'InstanceType' => [ 'shape' => 'InstanceType', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'LifecycleConfigName' => [ 'shape' => 'NotebookInstanceLifecycleConfigName', ], 'DisassociateLifecycleConfig' => [ 'shape' => 'DisassociateNotebookInstanceLifecycleConfig', ], 'VolumeSizeInGB' => [ 'shape' => 'NotebookInstanceVolumeSizeInGB', ], ], ], 'UpdateNotebookInstanceLifecycleConfigInput' => [ 'type' => 'structure', 'required' => [ 'NotebookInstanceLifecycleConfigName', ], 'members' => [ 'NotebookInstanceLifecycleConfigName' => [ 'shape' => 'NotebookInstanceLifecycleConfigName', ], 'OnCreate' => [ 'shape' => 'NotebookInstanceLifecycleConfigList', ], 'OnStart' => [ 'shape' => 'NotebookInstanceLifecycleConfigList', ], ], ], 'UpdateNotebookInstanceLifecycleConfigOutput' => [ 'type' => 'structure', 'members' => [], ], 'UpdateNotebookInstanceOutput' => [ 'type' => 'structure', 'members' => [], ], 'Url' => [ 'type' => 'string', 'max' => 1024, 'pattern' => '^(https|s3)://([^/]+)/?(.*)$', ], 'VariantName' => [ 'type' => 'string', 'max' => 63, 'pattern' => '^[a-zA-Z0-9](-*[a-zA-Z0-9])*', ], 'VariantWeight' => [ 'type' => 'float', 'min' => 0, ], 'VolumeSizeInGB' => [ 'type' => 'integer', 'min' => 1, ], 'VpcConfig' => [ 'type' => 'structure', 'required' => [ 'SecurityGroupIds', 'Subnets', ], 'members' => [ 'SecurityGroupIds' => [ 'shape' => 'VpcSecurityGroupIds', ], 'Subnets' => [ 'shape' => 'Subnets', ], ], ], 'VpcSecurityGroupIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecurityGroupId', ], 'max' => 5, 'min' => 1, ], ],];
